<?php
/**
 * @version     $Id$ 2.0.1 0
 * @package     Joomla
 * @copyright   Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license     GNU/GPL, see LICENSE.php
 *
 * added/fixed in version 2.0.1
 * - added the function nameUsed
 * - replace spaces from the name of the field to '_'
 * - remove the ';' at the end of the field values in case it was entered
 * - message can be renamed, published and made not required
 * - added an error message on name modification, unpublish or made not required the fields "name", "email" and "subject"
 * - "name", "email" and "subject" can't be deleted and an error message is displayed
 * - added 'aics_' in front of each field name
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// define the control_panel model class of aiContactSafe
class AiContactSafeModelFields extends AiContactSafeModelDefault {

	// construct function, it will iniaize the class variables
	function __construct( $default = array() )	{
		parent::__construct( $default );
		// if no order is used, use the 'ordering' field
		if (strlen($this->filter_order) == 0) {
			$this->filter_order = 'ordering';
			$this->filter_order_Dir = 'ASC';
		}
	}

	// function to check/add/modify different fields before writing them to the database
	function checkBeforeWrite($postData) {
		$returnData = $postData;
		// check if a name was entered
		if (strlen(trim($returnData['name'])) == 0) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			$this->_app->setUserState( 'errorMsg:' . $this->_sTask, JText::_( 'Please enter the name of the field.' ) );
		} else {
			$returnData['name'] = str_replace(' ','_',$returnData['name']);
			if ( substr($returnData['name'],0,5) != 'aics_' && $returnData['name'] != 'name' && $returnData['name'] != 'email' && $returnData['name'] != 'subject' && $returnData['name'] != 'send_to_sender'  ) {
				$returnData['name'] = 'aics_' . $returnData['name'];
			}
			if ( $this->nameUsed(trim($returnData['name']), $returnData['id']) ) {
				$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
				$this->_app->setUserState( 'errorMsg:' . $this->_sTask, JText::_( 'This name was used on another field. Please use a different one.' ) );
			} else {
				$returnData = parent::checkBeforeWrite($returnData);
			}
		}
		if (substr(trim($returnData['field_values']),-1,1) == ';') {
			$returnData['field_values'] = substr(trim($returnData['field_values']),0,-1);
		}
		
		$returnData['field_label'] = JRequest::getVar('field_label', '', 'post', 'string', JREQUEST_ALLOWHTML);
		$returnData['field_label'] = str_replace('"',"'",$returnData['field_label']);
		$returnData['field_label_message'] = JRequest::getVar('field_label_message', '', 'post', 'string', JREQUEST_ALLOWHTML);
		$returnData['field_label_message'] = str_replace('"',"'",$returnData['field_label_message']);
		
		$returnData['label_after_field'] = $returnData['label_after_field']?1:0;
		$returnData['field_required'] = $returnData['field_required']?1:0;
		$returnData['field_in_message'] = $returnData['field_in_message']?1:0;
		$returnData['published'] = $returnData['published']?1:0;
		$fieldError = false;
		// make sure the default fields are not changed and are published
		switch(true) {
			case $returnData['id'] == 1 :
				// name
				if ( $returnData['name'] != 'name' ){
					$returnData['name'] = 'name';
					$fieldError = true;
				}
				if ( $returnData['field_type'] != 'TX' ) {
					$returnData['field_type'] = 'TX';
					$fieldError = true;
				}
				if ( $returnData['field_required'] != 1 ){
					$returnData['field_required'] = 1;
					$fieldError = true;
				}
				if ( $returnData['published'] != 1 ){
					$returnData['published'] = 1;
					$fieldError = true;
				}
				break;
			case $returnData['id'] == 2 :
				// email
				if ( $returnData['name'] != 'email' ){
					$returnData['name'] = 'email';
					$fieldError = true;
				}
				if ( $returnData['field_type'] != 'TX' ) {
					$returnData['field_type'] = 'TX';
					$fieldError = true;
				}
				if ( $returnData['field_required'] != 1 ){
					$returnData['field_required'] = 1;
					$fieldError = true;
				}
				if ( $returnData['published'] != 1 ){
					$returnData['published'] = 1;
					$fieldError = true;
				}
				break;
			case $returnData['id'] == 4 :
				// subject
				if ( $returnData['name'] != 'subject' ){
					$returnData['name'] = 'subject';
					$fieldError = true;
				}
				if ( $returnData['field_type'] != 'TX' ) {
					$returnData['field_type'] = 'TX';
					$fieldError = true;
				}
				if ( $returnData['field_required'] != 1 ){
					$returnData['field_required'] = 1;
					$fieldError = true;
				}
				if ( $returnData['published'] != 1 ){
					$returnData['published'] = 1;
					$fieldError = true;
				}
				break;
			case $returnData['id'] == 6 :
				// subject
				if ( $returnData['name'] != 'send_to_sender' ){
					$returnData['name'] = 'send_to_sender';
					$fieldError = true;
				}
				if ( $returnData['field_type'] != 'CK' ) {
					$returnData['field_type'] = 'CK';
					$fieldError = true;
				}
				break;
		}
		if ( $fieldError ) {
			$this->_app->enqueueMessage(JText::_( 'NAME_EMAIL_SUBJECT_MODIFY_ERROR' ), 'error');
		}
		return $returnData;
	}

	// function used to modify the field published to 1 or 0
	function changePublish($state = 0) {
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// initialize different variables
		$db = & JFactory::getDBO();
		// read the ids of the records seleted for publishing / unpublishing
		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);
		if (count($cid) > 0) {
			$cids = '';
			// make sure the default fields are not unpublished
			for($i=0;$i<count($cid);$i++) {
				if ($cid[$i] != 1 && $cid[$i] != 2 && $cid[$i] != 4) {
					if (strlen($cids) > 0) {
						$cids .= ',';
					}
					$cids .= $cid[$i];
				} else {
					$this->_app->enqueueMessage(JText::_( 'NAME_EMAIL_SUBJECT_MODIFY_ERROR' ), 'error');
				}
			}
			if (strlen($cids) == 0) {
				$cids = '-1';
			}
		} else {
			$cids = '-1';
		}
		// update the value of the field published
		$ctablename = $this->getTableName($this->_sTask, 'changePublish');
		$query = 'update '.$ctablename.' set published = ' . $state . ' where id IN ( ' . $cids . ' )';
		$db->setQuery($query);
		if (!$db->query()) {
			JError::raiseError( 500, $db->getErrorMsg() );
			return false;
		}

		return true;
	}

	// function check if the field name is used on the database for a different field
	function nameUsed( $checkName = '', $checkId = 0) {
		// initialize different variables
		$db = & JFactory::getDBO();

		// count all the fileds with the same name and a different id
		$query = 'select count(*) as count_fields from #__aicontactsafe_fields where name = \'' . $checkName . '\' and id != ' . (int)$checkId;

		$db->setQuery($query);
		$count_fields = $db->loadResult();

		return $count_fields;
	}

	// function to generate the condition records have to respect to be selected for deletion
	function getDeleteWhere($cids = '-1') {
		$ctablename = $this->getTableName($this->_sTask, 'getDeleteWhere');
		$cids = explode(',', $cids);
		$countCids = count($cids);
		for($i=0;$i<$countCids;$i++){
			if ( $cids[$i] == 1 || $cids[$i] == 2 || $cids[$i] == 4 ) {
				$this->_app->enqueueMessage(JText::_( 'NAME_EMAIL_SUBJECT_DELETE_ERROR' ), 'error');
				$cids[$i] = 0;
			}
		}
		$cids = implode(',', $cids);
		$where = ' where ' . $ctablename . '.id IN ( ' . $cids . ' )';
		return $where;
	}
}
?>
