<?php
/**
 * @version     $Id$ 2.0.1 0
 * @package     Joomla
 * @copyright   Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license     GNU/GPL, see LICENSE.php
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// define the control_panel model class of aiContactSafe
class AiContactSafeModelProfiles extends AiContactSafeModelDefault {

	// function to check/add/modify different fields before writing them to the database
	function checkBeforeWrite($postData) {
		$returnData = $postData;
		// check if a name was entered
		if (strlen(trim($returnData['name'])) == 0) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			$this->_app->setUserState( 'errorMsg:' . $this->_sTask, JText::_( 'Please enter the name of the profile.' ) );
		} else {
			$returnData = parent::checkBeforeWrite($returnData);
		}

		$returnData['use_message_css'] = $returnData['use_message_css']?1:0;
		$returnData['use_profile_css'] = $returnData['use_profile_css']?1:0;
		$returnData['use_captcha'] = $returnData['use_captcha']?1:0;
		$returnData['always_send_to_email_address'] = $returnData['always_send_to_email_address']?1:0;
		$returnData['record_message'] = $returnData['record_message']?1:0;

		$returnData['required_field_mark'] = JRequest::getVar('required_field_mark', '', 'post', 'string', JREQUEST_ALLOWHTML);
		$returnData['required_field_mark'] = str_replace('"',"'",$returnData['required_field_mark']);

		$returnData['set_default'] = $returnData['set_default']?1:0;
		if ( $returnData['set_default'] == 1 ) {
			$this->resetDefaultProfile();
		} else {
			$returnData['set_default'] = $this->checkDefaultProfile( $returnData['id'] );
		}
		$returnData['published'] = $returnData['published']?1:0;
		if ( $returnData['all_fields'] ) {
			$returnData['active_fields'] = 0;
		} else {
			$fieldError = false;
			if ( array_search(1,$returnData['select_fields']) === false ) {
				$returnData['select_fields'][] = 1;
				$fieldError = true;
			}
			if ( array_search(2,$returnData['select_fields']) === false ) {
				$returnData['select_fields'][] = 2;
				$fieldError = true;
			}
			if ( array_search(4,$returnData['select_fields']) === false ) {
				$returnData['select_fields'][] = 4;
				$fieldError = true;
			}
			if ( $fieldError ) {
				$this->_app->enqueueMessage(JText::_( 'NAME_EMAIL_SUBJECT_PROFILE_FIELDS_ERROR' ), 'error');
			}
			$returnData['active_fields'] = implode(',', $returnData['select_fields']);
		}

		return $returnData;
	}

	// function to reset the default profile
	function resetDefaultProfile() {
		// initialize the database
		$db = &JFactory::getDBO();
		// reset field set_default to 0 for all records
		$query = 'UPDATE `#__aicontactsafe_profiles` SET set_default = 0';
		$db->setQuery( $query );
		$db->query();
	}

	// function to check if the default profile was deactivated
	function checkDefaultProfile( $id = 0 ) {
		$id = (int)$id;
		// initialize the database
		$db = &JFactory::getDBO();
		// reset field set_default to 0 for all records
		$query = 'SELECT set_default FROM `#__aicontactsafe_profiles` WHERE id = '.$id;
		$db->setQuery( $query );
		$set_default = $db->loadResult();
		if ($set_default == 1) {
			$this->_app->enqueueMessage(JText::_( 'DEACTIVATE_DEFAULT_ERROR' ), 'error');
		}
		return $set_default;
	}

	//function to write data in other tables then the default one of the current sTask
	function writeOtherTables( $postData = array(), $id = 0 ) {
		// get the information in the form
		$id = (int)$id;
		$name = $postData['name'];
		$contact_info = JRequest::getVar('contact_info', '', 'post', 'string', JREQUEST_ALLOWHTML);
		$contact_info = str_replace("'","&prime;",$contact_info);
		$meta_description = $postData['meta_description'];
		$meta_keywords = $postData['meta_keywords'];
		$thank_you_message = $postData['thank_you_message'];

		// initialize the database
		$db = &JFactory::getDBO();

		// save contact_info
		$query = 'SELECT id FROM #__aicontactsafe_contactinformations WHERE profile_id = ' . $id . ' and info_key = \'contact_info\'';
		$db->setQuery( $query );
		$added = $db->loadResult();
		if ($added > 0) {
			$query = 'UPDATE `#__aicontactsafe_contactinformations` set info_label = \'contact_info (' . $name . ')\', info_value = \'' . $contact_info . '\' WHERE profile_id = ' . $id . ' and info_key = \'contact_info\'';
		} else {
			$query = 'INSERT INTO `#__aicontactsafe_contactinformations` (`id`, `profile_id`, `info_key`, `info_label`, `info_value`) VALUES (null, ' . $id . ', \'contact_info\', \'contact_info (' . $name . ')\', \'' . $contact_info . '\')';
		}
		$db->setQuery( $query );
		$db->query();

		// save meta_description
		$query = 'SELECT id FROM #__aicontactsafe_contactinformations WHERE profile_id = ' . $id . ' and info_key = \'meta_description\'';
		$db->setQuery( $query );
		$added = $db->loadResult();
		if ($added > 0) {
			$query = 'UPDATE `#__aicontactsafe_contactinformations` set info_label = \'meta_description (' . $name . ')\', info_value = \'' . $meta_description . '\' WHERE profile_id = ' . $id . ' and info_key = \'meta_description\'';
		} else {
			$query = 'INSERT INTO `#__aicontactsafe_contactinformations` (`id`, `profile_id`, `info_key`, `info_label`, `info_value`) VALUES (null, ' . $id . ', \'meta_description\', \'meta_description (' . $name . ')\', \'' . $meta_description . '\')';
		}
		$db->setQuery( $query );
		$db->query();

		// save meta_keywords
		$query = 'SELECT id FROM #__aicontactsafe_contactinformations WHERE profile_id = ' . $id . ' and info_key = \'meta_keywords\'';
		$db->setQuery( $query );
		$added = $db->loadResult();
		if ($added > 0) {
			$query = 'UPDATE `#__aicontactsafe_contactinformations` set info_label = \'meta_keywords (' . $name . ')\', info_value = \'' . $meta_keywords . '\' WHERE profile_id = ' . $id . ' and info_key = \'meta_keywords\'';
		} else {
			$query = 'INSERT INTO `#__aicontactsafe_contactinformations` (`id`, `profile_id`, `info_key`, `info_label`, `info_value`) VALUES (null, ' . $id . ', \'meta_keywords\', \'meta_keywords (' . $name . ')\', \'' . $meta_keywords . '\')';
		}
		$db->setQuery( $query );
		$db->query();

		// save thank you message
		$query = 'SELECT id FROM #__aicontactsafe_contactinformations WHERE profile_id = ' . $id . ' and info_key = \'thank_you_message\'';
		$db->setQuery( $query );
		$added = $db->loadResult();
		if ($added > 0) {
			$query = 'UPDATE `#__aicontactsafe_contactinformations` set info_label = \'thank_you_message (' . $name . ')\', info_value = \'' . $thank_you_message . '\' WHERE profile_id = ' . $id . ' and info_key = \'thank_you_message\'';
		} else {
			$query = 'INSERT INTO `#__aicontactsafe_contactinformations` (`id`, `profile_id`, `info_key`, `info_label`, `info_value`) VALUES (null, ' . $id . ', \'thank_you_message\', \'thank_you_message (' . $name . ')\', \'' . $thank_you_message . '\')';
		}
		$db->setQuery( $query );
		$db->query();

		return true;
	}

	// function to get the contact informations of the current profile
	function getContactInformation( $profile_id = 0 ) {
		// initialize contact informations
		$contact_info = array();
		$contact_info['contact_info'] = '';
		$contact_info['meta_description'] = '';
		$contact_info['meta_keywords'] = '';
		$contact_info['thank_you_message'] = '';

		// initialize the database
		$db = &JFactory::getDBO();

		// get contact informations
		$query = 'SELECT info_key, info_value FROM #__aicontactsafe_contactinformations WHERE profile_id = ' . $profile_id;
		$db->setQuery( $query );
		$records = $db->loadObjectList();
		if ( count($records) > 0 ) {
			foreach($records as $record) {
				switch($record->info_key) {
					case 'contact_info' :
						$contact_info['contact_info'] = $record->info_value;
						break;
					case 'meta_description' :
						$contact_info['meta_description'] = $record->info_value;
						break;
					case 'meta_keywords' :
						$contact_info['meta_keywords'] = $record->info_value;
						break;
					case 'thank_you_message' :
						$contact_info['thank_you_message'] = $record->info_value;
						break;
				}
			}
		}
		
		return $contact_info;
	}

	// function to retrive the fields to select the ones active in a profile
	function getFields( $active_fields = '' ) {
		$active_fields = explode(',',$active_fields);
		// initialize the response array
		$fields = array();
		// initialize the database
		$db = &JFactory::getDBO();
		// get all the fields
		$query = 'SELECT id, name, field_label FROM #__aicontactsafe_fields ORDER BY ordering';
		$db->setQuery( $query );
		$records = $db->loadObjectList();
		foreach($records as $record) {
			$fields[] = array('id'=>$record->id, 'name'=>$record->name, 'field_label'=>$record->field_label, 'selected'=>(array_search($record->id, $active_fields) === false)?'0':'1');
		}
		return $fields;
	}

	// function to generate the condition records have to respect to be selected for deletion
	function getDeleteWhere($cids = '-1') {
		// initialize the database
		$db = &JFactory::getDBO();
		// get the default record
		$query = 'SELECT id FROM `#__aicontactsafe_profiles` WHERE set_default = 1';
		$db->setQuery( $query );
		$id = $db->loadResult();

		$ctablename = $this->getTableName($this->_sTask, 'getDeleteWhere');
		$cids = explode(',', $cids);
		$countCids = count($cids);
		for($i=0;$i<$countCids;$i++){
			if ( $cids[$i] == $id ) {
				$this->_app->enqueueMessage(JText::_( 'DEFAULT_PROFILE_DELETE_ERROR' ), 'error');
				$cids[$i] = 0;
			}
		}
		$cids = implode(',', $cids);
		$where = ' where ' . $ctablename . '.id IN ( ' . $cids . ' )';
		return $where;
	}


}
?>
