<?php
/**
* @version		$Id: view.html.php 928 2008-03-30 10:51:32Z akede $
* @package		Joomla
* @subpackage	Weblinks
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

JLoader::import( 'views.abstract.joomfishview',JPATH_COMPONENT_ADMINISTRATOR);

/**
 * HTML View class for the WebLinks component
 *
 * @static
 * @package		Joomla
 * @subpackage	Weblinks
 * @since 1.0
 */
class ElementsViewElements extends JoomfishAbstractView 
{
	function display($tpl = null)
	{
		$document =& JFactory::getDocument();
		// this already includes administrator
		$livesite = JURI::base();
		$document->addStyleSheet($livesite.'components/com_joomfish/assets/css/joomfish.css');

		$layout = $this->getLayout();
		if (method_exists($this,$layout)){
			return $this->$layout($tpl);
		}

		parent::display($tpl);
	}
	
	
	function overview($tpl = null)
	{
		$document =& JFactory::getDocument();
		// browser title
		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('Content elements'));
		
		// set page title
		JToolBarHelper::title( JText::_( 'Content elements' ), 'extension' );

		// Set toolbar items for the page
		JToolBarHelper::custom("elements.installer","archive","archive", JText::_( 'INSTALL' ),false);
		JToolBarHelper::custom("elements.detail","preview","preivew", JText::_( 'DETAIL' ),true);
		JToolBarHelper::deleteList(JText::_("ARE YOU SURE YOU WANT TO DELETE THIS CE FILE"), "elements.remove");
		JToolBarHelper::custom( 'cpanel.show', 'joomfish', 'joomfish', JText::_( 'CONTROL PANEL' ), false );
		JToolBarHelper::help( 'elements.show', true);

		// hide the sub menu
		$this->_hideSubmenu();	
			
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}	
	
	function element($tpl = null)
	{
		// browser title
		$document =& JFactory::getDocument();
		// browser title
		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('Content elements'));
		
		// set page title
		JToolBarHelper::title( JText::_( 'Content elements' ), 'extension' );
		
		// Set toolbar items for the page
		JToolBarHelper::back();
		JToolBarHelper::custom( 'cpanel.show', 'joomfish', 'joomfish', JText::_( 'CONTROL PANEL' ), false );
		JToolBarHelper::help( 'elements.show', true);

		// hide the sub menu
		$this->_hideSubmenu();		
			
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}	

	function installer($tpl = null)
	{
		// browser title
		$document =& JFactory::getDocument();
		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('CONTENT ELEMENT INSTALLER'));
		
		// set page title
		JToolBarHelper::title( JText::_('JOOMFISH_TITLE') .' :: '. JText::_( 'CONTENT ELEMENT INSTALLER' ), 'fish' );

		// Set toolbar items for the page
		JToolBarHelper::back();
		JToolBarHelper::custom( 'cpanel.show', 'joomfish', 'joomfish', JText::_( 'CONTROL PANEL' ), false );
		JToolBarHelper::help( 'elements.installer', true);

		// hide the sub menu
		$this->_hideSubmenu();
					
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}	
}
