<?php
/**
 * @version     $Id$ 2.0.1 0
 * @package     Joomla
 * @copyright   Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license     GNU/GPL, see LICENSE.php
 *
 * added/fixed in version 2.0.1
 * - fixed the problem with the apostrophe in contact information
 * - added custom field date format
 * - added mark_required_fields character
 * - added always_send_to_defaut
 * - added Artio activation
 * - added Joom!Fish activation
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// define the control_panel model class of aiContactSafe
class AiContactSafeModelControl_panel extends AiContactSafeModelDefault {

	// function to write data to database
	function writeData() {
		// get the table where to read
		$tablename = $this->getTableName();
		// remove the chars '#__' form the front of the name of the table
		$ctablename = substr($tablename,3);
		$postData = $this->_app->getUserState( 'postData:' . $this->_sTask );

		// read the config variables from the post data
		$use_css_backend = ($postData['use_css_backend'])?'1':'0';
		$activate_help = ($postData['activate_help'])?'1':'0';
		$date_format = $postData['date_format'];
		$activate_spam_control = ($postData['activate_spam_control'])?'1':'0';
		$block_words = $postData['block_words'];
		$record_blocked_messages = ($postData['record_blocked_messages'])?'1':'0';
		$activate_ip_ban = ($postData['activate_ip_ban'])?'1':'0';
		$ban_ips = $postData['ban_ips'];
		$redirect_ips = $postData['redirect_ips'];
		$upload_attachments = str_replace('\\','&#92;',$postData['upload_attachments']);
		$maximum_size = $postData['maximum_size'];
		$attachments_types = $postData['attachments_types'];
		$attach_to_email = ($postData['attach_to_email'])?'1':'0';

		// initialize the database
		$db = & JFactory::getDBO();

		// save use_css_backend
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $use_css_backend . '\' where config_key = \'use_css_backend\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save activate_help
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $activate_help . '\' where config_key = \'activate_help\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save date_format
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $date_format . '\' where config_key = \'date_format\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save activate_spam_control
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $activate_spam_control . '\' where config_key = \'activate_spam_control\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save block_words
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $block_words . '\' where config_key = \'block_words\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save record_blocked_messages
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $record_blocked_messages . '\' where config_key = \'record_blocked_messages\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save activate_ip_ban
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $activate_ip_ban . '\' where config_key = \'activate_ip_ban\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save ban_ips
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $ban_ips . '\' where config_key = \'ban_ips\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save redirect_ips
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $redirect_ips . '\' where config_key = \'redirect_ips\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save upload_attachments
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $upload_attachments . '\' where config_key = \'upload_attachments\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save maximum_size
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $maximum_size . '\' where config_key = \'maximum_size\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save redirect_ips
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $attachments_types . '\' where config_key = \'attachments_types\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}
		// save attach_to_email
		$query = 'update `#__aicontactsafe_config` set config_value = \'' . $attach_to_email . '\' where config_key = \'attach_to_email\'';
		$db->setQuery( $query );
		$isOK = $db->query();
		if (!$isOK) {
			$this->_app->setUserState( 'isOK:' . $this->_sTask, false );
			JError::raiseError( 500, $db->getErrorMsg() );
		}

		$isOK = $this->_app->getUserState( 'isOK:' . $this->_sTask );

		return $isOK;
	}

	// function to determine the table to write to
	function getTableName($sTask = '') {
		$tablename = '#__aicontactsafe_config';
		return $tablename;
	}

	// function to delete all the tables and files uploaded by AiContactSafe
	function deleteTablesAndFiles() {
		// initialize the database
		$db = &JFactory::getDBO();

		// #__aicontactsafe_config
		$query = 'TRUNCATE TABLE `#__aicontactsafe_config`;';
		$db->setQuery( $query );
		$db->query();
		$query = 'DROP TABLE IF EXISTS `#__aicontactsafe_config`;';
		$db->setQuery( $query );
		$db->query();
		// #__aicontactsafe_fields
		$query = 'TRUNCATE TABLE `#__aicontactsafe_fields`;';
		$db->setQuery( $query );
		$db->query();
		$query = 'DROP TABLE IF EXISTS `#__aicontactsafe_fields`;';
		$db->setQuery( $query );
		$db->query();
		// #__aicontactsafe_contactinformations
		$query = 'TRUNCATE TABLE `#__aicontactsafe_contactinformations`;';
		$db->setQuery( $query );
		$db->query();
		$query = 'DROP TABLE IF EXISTS `#__aicontactsafe_contactinformations`;';
		$db->setQuery( $query );
		$db->query();
		// #__aicontactsafe_messages
		$query = 'TRUNCATE TABLE `#__aicontactsafe_messages`;';
		$db->setQuery( $query );
		$db->query();
		$query = 'DROP TABLE IF EXISTS `#__aicontactsafe_messages`;';
		$db->setQuery( $query );
		$db->query();
		// #__aicontactsafe_profiles
		$query = 'TRUNCATE TABLE `#__aicontactsafe_profiles`;';
		$db->setQuery( $query );
		$db->query();
		$query = 'DROP TABLE IF EXISTS `#__aicontactsafe_profiles`;';
		$db->setQuery( $query );
		$db->query();
		// #__aicontactsafe_messagefiles
		$query = 'TRUNCATE TABLE `#__aicontactsafe_messagefiles`;';
		$db->setQuery( $query );
		$db->query();
		$query = 'DROP TABLE IF EXISTS `#__aicontactsafe_messagefiles`;';
		$db->setQuery( $query );
		$db->query();

		// delete records from joomfish
		// #__jf_tableinfo
		$query = 'DELETE FROM `#__jf_tableinfo` WHERE joomlatablename = \'aicontactsafe_contactinformations\' or joomlatablename = \'aicontactsafe_fields\';';
		$db->setQuery( $query );
		$db->query();
		// #__jf_content
		$query = 'DELETE FROM `#__jf_content` WHERE reference_table = \'aicontactsafe_contactinformations\' or reference_table = \'aicontactsafe_fields\';';
		$db->setQuery( $query );
		$db->query();

	}

	// function to check if artio is installed and the aiContactSafe plugin is installed
	// return
	// - 0 if Artio is not installed
	// - 1 if Artio is installed but the aiContactSafe plugin is not installed
	// - 2 if Artio is installed and the aiContactSafe plugin is installed
	function check_artio() {
		$return = 0;

		// import joomla clases to manage file system
		jimport('joomla.filesystem.file');

		$artio = JPath::clean(JPATH_ROOT.DS.'components'.DS.'com_sef'.DS.'sef_ext');
		if (is_dir($artio)) {
			$return = 1;
			$com_aicontactsafe_php = JPath::clean(JPATH_ROOT.DS.'components'.DS.'com_sef'.DS.'sef_ext'.DS.'com_aicontactsafe.php');
			$com_aicontactsafe_xml = JPath::clean(JPATH_ROOT.DS.'components'.DS.'com_sef'.DS.'sef_ext'.DS.'com_aicontactsafe.xml');
			if (is_file($com_aicontactsafe_php) && is_file($com_aicontactsafe_xml)) {
				$return = 2;
			}
		}

		return $return;
	}
	
	// function to check if Joom!Fish is installed and the content elements for aiContactSafe are installed
	// return
	// - 0 if Joom!Fish is not installed
	// - 1 if Joom!Fish is installed but the aiContactSafe content elements are not installed
	// - 2 if Joom!Fish is installed and the aiContactSafe content elements are installed
	function check_joomfish() {
		$return = 0;

		// import joomla clases to manage file system
		jimport('joomla.filesystem.file');

		$contentelements = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_joomfish'.DS.'contentelements');
		if (is_dir($contentelements)) {
			$return = 1;
			$aicontactsafe_contactinformations = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_joomfish'.DS.'contentelements'.DS.'aicontactsafe_contactinformations.xml');
			$aicontactsafe_fields = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_joomfish'.DS.'contentelements'.DS.'aicontactsafe_fields.xml');
			if (is_file($aicontactsafe_contactinformations) && is_file($aicontactsafe_fields)) {
				$return = 2;
			}
		}

		return $return;
	}

	// function to activate aiContactSafe in Artio
	function activate_artio() {
		// import joomla clases to manage file system
		jimport('joomla.filesystem.file');

		$src = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_aicontactsafe'.DS.'includes'.DS.'artio'.DS.'com_aicontactsafe.php');
		$dest = JPath::clean(JPATH_ROOT.DS.'components'.DS.'com_sef'.DS.'sef_ext'.DS.'com_aicontactsafe.php');
		JFile::copy($src, $dest);
		$src = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_aicontactsafe'.DS.'includes'.DS.'artio'.DS.'com_aicontactsafe.xml');
		$dest = JPath::clean(JPATH_ROOT.DS.'components'.DS.'com_sef'.DS.'sef_ext'.DS.'com_aicontactsafe.xml');
		JFile::copy($src, $dest);
	}

	// function to deactivate aiContactSafe in Artio
	function deactivate_artio() {
		// import joomla clases to manage file system
		jimport('joomla.filesystem.file');

		$com_aicontactsafe = JPath::clean(JPATH_ROOT.DS.'components'.DS.'com_sef'.DS.'sef_ext'.DS.'com_aicontactsafe.php');
		if (is_file($com_aicontactsafe)) {
			JFile::delete($com_aicontactsafe);
		}
		$com_aicontactsafe = JPath::clean(JPATH_ROOT.DS.'components'.DS.'com_sef'.DS.'sef_ext'.DS.'com_aicontactsafe.xml');
		if (is_file($com_aicontactsafe)) {
			JFile::delete($com_aicontactsafe);
		}
	}

	// function to activate aiContactSafe in Joom!Fish
	function activate_joomfish() {
		// import joomla clases to manage file system
		jimport('joomla.filesystem.file');

		$src = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_aicontactsafe'.DS.'includes'.DS.'joomfish'.DS.'aicontactsafe_contactinformations.xml');
		$dest = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_joomfish'.DS.'contentelements'.DS.'aicontactsafe_contactinformations.xml');
		JFile::copy($src, $dest);
		$src = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_aicontactsafe'.DS.'includes'.DS.'joomfish'.DS.'aicontactsafe_fields.xml');
		$dest = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_joomfish'.DS.'contentelements'.DS.'aicontactsafe_fields.xml');
		JFile::copy($src, $dest);
	}

	// function to deactivate aiContactSafe in Joom!Fish
	function deactivate_joomfish() {
		// import joomla clases to manage file system
		jimport('joomla.filesystem.file');

		$aicontactsafe_contactinformations = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_joomfish'.DS.'contentelements'.DS.'aicontactsafe_contactinformations.xml');
		if (is_file($aicontactsafe_contactinformations)) {
			JFile::delete($aicontactsafe_contactinformations);
		}
		$aicontactsafe_fields = JPath::clean(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_joomfish'.DS.'contentelements'.DS.'aicontactsafe_fields.xml');
		if (is_file($aicontactsafe_fields)) {
			JFile::delete($aicontactsafe_fields);
		}
	}

	// function to check if the message section in the template is activated
	function checkMessageSection() {
		// initialize the database
		$db = & JFactory::getDBO();

		// save use_css_backend
		$query = 'SELECT template FROM `#__templates_menu` where client_id = 0 and ( menuid = 0 or menuid in ( select id from `#__menu` where link like \'%option=com_aicontactsafe%\' ) )';
		$db->setQuery( $query );
		$templates = $db->loadResultArray();
		
		// import joomla clases to manage file system
		jimport('joomla.filesystem.file');

		$rspTemplates = array();
		foreach($templates as $template) {
			$indexFile = JPATH_ROOT.DS.'templates'.DS.$template.DS.'index.php';
			$fileTemplate = JFile::read($indexFile);
			$cntMessageSection = substr_count($fileTemplate, '<jdoc:include type="message" />');
			if ( $cntMessageSection == 0 ) {
				$rspTemplates[] = $template;
			}
		}
		return $rspTemplates;
	}

}
?>
